@extends('layouts.app')

@section('title', '500 Internal Server Error')

@section('content')
<div class="error-container">
    <div class="error-image">
        <svg xmlns="http://www.w3.org/2000/svg" class="feather feather-server" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
            <rect x="2" y="2" width="20" height="8" rx="2" ry="2" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></rect>
            <rect x="2" y="14" width="20" height="8" rx="2" ry="2" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></rect>
            <line x1="6" y1="6" x2="6" y2="6" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></line>
            <line x1="6" y1="18" x2="6" y2="18" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></line>
        </svg>
    </div>
    
    <h1 class="error-code">500</h1>
    <h2 class="error-title">Internal Server Error</h2>
    
    <p class="error-message">
        Something went wrong on our end. Please try again later or contact support if the problem persists.
    </p>
    
    <div class="error-actions">
        <a href="{{ url()->previous() }}" class="btn btn-primary">Go Back</a>
        <a href="{{ url('/') }}" class="btn btn-secondary">Home</a>
    </div>
</div>
@endsection
